macroscript IllusionOut category:"Illusion"
(
global ilex_float

rollout ilex_roll "Illusion Exporter"
(
pickbutton source_object ">Pick Object To Export..." width:200 align:#center
group "Export Settings:"
(
spinner render_width "Width:" range:[32,32000,RenderWidth] type:#integer across:2 align:#left fieldwidth:45
spinner render_height "Height:" range:[24,24000,RenderHeight] type:#integer align:#right fieldwidth:45
button get_from_max "Get Size From Renderer" align:#center width:190
)

group "Timing:"
(
spinner s_time "S:" range:[-1,100000,animationrange.start] type:#integer across:3 align:#left fieldwidth:35 enabled:false
spinner e_time "E:" range:[0,100000,animationrange.end] type:#integer align:#center fieldwidth:35 enabled:false
spinner w_time "Nth:" range:[0,1000,1] type:#integer align:#center fieldwidth:30 enabled:false
radiobuttons time_mode labels:#("Scene Range","User Segment")
)

on time_mode changed state do
(
s_time.enabled = e_time.enabled = w_time.enabled = state != 1
)

on get_from_max pressed do
(
render_width.value = RenderWidth
render_height.value = RenderHeight
)

button export_file "EXPORT TO ILLUSION" width:200 height:30 align:#center enabled:false

group "Options:"
(
radiobuttons use_pivot labels:#("Use Pivot","Use BBox Center")
checkbox see_file "See File After Export" checked:false
checkbox watch_rendering "Watch Control Rendering" checked:false
)

on source_object picked obj do
(
work_node = obj
source_object.text = obj.name
export_file.enabled = true
)

on export_file pressed do
(
test_camera = viewport.GetCamera()
if test_camera != undefined then
(
out_name = work_node.name+".txt"
output_destination = getSaveFileName filename:out_name caption:"Export Illusion File to:" types:"Illusion Text File (*.txt)|*.txt|All Files (*.*)|*.*|"

if output_destination != undefined then
	(
	out_file = createfile output_destination
	
	if time_mode.state == 1 then
	(
	start_time = (animationrange.start as float / TicksPerFrame) as integer
	end_time = (animationrange.end as float /TicksPerFrame) as integer
	step_time = 1
	if start_time > end_time then step_time = -step_time 
	)
	else
	(
	start_time = s_time.value
	end_time = e_time.value
	step_time = w_time.value
	if start_time > end_time then step_time = -step_time 
	)
	
	screen_width=render_width.value as float
	screen_height=render_height.value as float
	temp_vfb = bitmap screen_width screen_height
	red_dot = #((color 255 0 0))
	red_line = #()
	for i = 1 to screen_width do append red_line (color 255 0 0)
	
	try
	(
	for t = start_time to end_time by step_time do
	(
		at time t 
		(
			if use_pivot.state == 1 then
			(
			in coordsys test_camera a = work_node.pos
			)
			else
			(
			in coordsys test_camera a = work_node.center
			)
			zero_origin = mapScreenToView [0,0] (a.z) [screen_width,screen_height]
			end_screen  = mapScreenToView [screen_width,screen_height] (a.z) [screen_width,screen_height]
			world_size = zero_origin-end_screen
			x_aspect = screen_width/(abs world_size.x)
			y_aspect = screen_height/(abs world_size.y)
			a_screen = point2 ((x_aspect*(a.x-zero_origin.x))) (1+(abs(y_aspect*(a.y-zero_origin.y))))
			format "%\t%\t%\n" t a_screen.x a_screen.y to:out_file
			if watch_rendering.checked then
				(
				rend_bmp = render frame:t vfb:off
				copy rend_bmp temp_vfb
				setpixels temp_vfb [0,a_screen.y-1] red_line
				for i = 1 to screen_height do 
					(
					setpixels temp_vfb [a_screen.x,i-1] red_dot
					)
				display temp_vfb	
				)
				
		)--end time
	)--end t loop	
	)
	catch
	(
	messagebox "Some SEVERE error occured!" title:"Illusion Exporter ERROR:"
	)
	close out_file
	close temp_vfb
	gc()
	if see_file.checked then edit output_destination 
	)--end if 
)
else
(
messagebox "The active Viewport is NOT a Camera Viewport!\nPlease select a Camera Viewport first..." title:"Illusion Exporter WARNING:"
)
)--end on

)--end roll

rollout about_ilex "About..."
(
label about01 "ILLUSION EXPORTER for MAX R3.x"
label about02 "Version 0.1 - 03/07/2000"
label about03 "by Borislav Petrov"
label about04 "http://gfxcentral.com/bobo/"
label about05 ""
label about06 "Developed for "
label about07 "Alan Lorence"
label about08 "http://coolfun.com/illusion"

)--end roll

try(closerolloutfloater ilex_float)catch()
ilex_float = newrolloutfloater "Illusion Exporter v0.1" 240 370 100 100
addrollout ilex_roll ilex_float
addrollout about_ilex ilex_float rolledup:true
)--end script